;								EJEMPLO 37
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;El mdulo USART. Recepcin asncrona. 
;
;El mdulo USART de los dispositivos PIC16F87X incorpora el hardware necesario para implemen-
;tar comunicacin serie asncrona full-duplex o sincrona half-duplex. En este ltimo caso el
;USART se puede comportar como Master o Slave.
;
;En el ejemplo se provoca una interrupcin cada vez que se recibe un carcter va serie. El
;programa de tratamiento visualiza, sobre los leds del laboratorio conectados a la Puerta B,
;el cdigo binario del carcter recibido. Igualmente retransmite el carcter recibido, a 
;modo de ECO.

		List	p=16F876A		;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos

;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

			__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC

			org	0x00		;Vector de RESET	
			goto	Inicio
			org	0x04		;Vector de interrupcin
			goto	Inter
			org	0x05

;********************************************************************************************
;Tx_Dato: Transmite va serie el dato presente en el reg. W

Tx_Dato			bcf		PIR1,TXIF	;Restaura el flag del transmisor
				movwf	TXREG		;Almacena el byte a transmitir
				bsf		STATUS,RP0
Tx_Dato_Wait	btfss	TXSTA,TRMT	;Byte transmitido ??
				goto	Tx_Dato_Wait;No, esperar
				bcf		STATUS,RP0
				return				;Si

;******************************************************************************************
;Tratamiento de la interrupcin

Inter			btfss	PIR1,RCIF	;Ha sido interrupcin en la recepcin ??
				retfie				;No, falsa interrupcin
				bcf		PIR1,RCIF	;Si, restaurar el flag de interrupcin
				movf	RCREG,W		;Lee el dato recibido
				movwf	PORTB		;Lo saca por la puerta B
				call	Tx_Dato		;Lo retransmite a modo de eco
				retfie

;*******************************************************************************************
;Programa principal

Inicio	     	clrf	PORTC		
				clrf	PORTB
				bsf		STATUS,RP0	;Selecciona banco 1
				clrf	PORTB		;Puerta B salida
				movlw	b'10111111'
				movwf	TRISC		;RC7/Rx entrada, RC6/Tx salida	
				movlw	b'00100100'	
				movwf	TXSTA		;TX en On, modo asncrono con 8 bits y alta velocidad
				movlw	.25
				movwf	SPBRG		;9600 baudios con Fosc=4MHz
				bsf		PIE1,RCIE	;Habilita interrupcin en la recepcin
				bcf		STATUS,RP0	;Selecciona banco 0
		
				movlw	b'10010000'
				movwf	RCSTA		;USART en On, recepcin contnua
				bsf		INTCON,PEIE	;Activa interrupcin de perifricos
				bsf		INTCON,GIE	;Activa interrupciones

Loop			nop
				goto	Loop

				end					;Fin del programa fuente
